% main file

clear all;
clc;
% ===================================================================
%--- Basic configuration parameters and variables
N = 4;                              % channel size   4x4
Sigma = 0.1*ones(N) + 0.9*eye(N);   % according task definition
df = 8;                             % according task definition
K = 5000;                           % number of samples for statistics
A = zeros(N,N,K);                   % channel matrix
x = zeros(N,K);                     % Tx signal
b = x;                              % b - Rx signal (b = Ax + n)
% ---
snr = -10:2:10;                     % setup of testing points (dB)
err_p = zeros(1,length(snr));   	% probability of errors (statistics)
err_vec = zeros(1,length(snr));		% bit error vector
% ===================================================================
A = ch_gen(Sigma,df,K);             % generation of channel matrix
                                    % according Wishard distribution
% information sequence:
s = randi(2,1,K)*2-3;   % random signal  +1   or   -1

% Tx signal generation and precoder calculation
p_tx = precoding(A,K,N);
x = tx_signal_gen (s,p_tx);

b = add_channel(A,x);
idx = 0;
for SNR=snr,		% SNR loop

	idx = idx + 1;
	
	b_noise = add_noise(b,SNR);
	
	[x_est s_est] = receiver(A,p_tx,b_noise);
	err_vec(idx) = sum(abs(s-s_est)/2);
	err_p(idx) = err_vec(idx) / K;
	fprintf('\nSimulating for SNR\t%ddB\t\t%.2f',SNR,err_p(idx));
end					% end of SNR loop
fprintf('\n');
semilogy(snr,err_p,'mo-','MarkerSize',10,'MarkerFaceColor',[0 0 0],'LineWidth',3);
axis([-10 10 1e-3 1]);
grid on;
xlabel('SNR','FontWeight','bold','FontName','Arial');
ylabel('Probability error','FontWeight','bold','FontName','Arial');